import javax.swing.*;
import java.awt.event.*;

public class Application extends JFrame implements ActionListener{
  protected JButton btnStart;
  protected JButton btnStop;
  protected JLabel lblProgeess;
  protected int progress;
  protected Thread thread;
  public Application() {
    super();
    setSize(320, 200);
    setLayout(null);
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setTitle("Aplikacja w Javie");
    
    btnStart = new JButton("Start");
    btnStart.setBounds(45, 120, 100, 30);
    btnStart.setActionCommand("Start");
    btnStart.addActionListener(this);
    add(btnStart);

    btnStop = new JButton("Stop");
    btnStop.setBounds(165, 120, 100, 30);
    btnStop.setActionCommand("Stop");
    btnStop.addActionListener(this);
    add(btnStop);

    lblProgeess = new JLabel("0%");
    lblProgeess.setBounds(150, 60, 40, 20);
    add(lblProgeess);
        
    btnStart.setEnabled(true);
    btnStop.setEnabled(false);
    
    setVisible(true);
  }
  public void actionPerformed(ActionEvent e)
  {
    String cmd = e.getActionCommand();
    if ("Start".equals(cmd)){
      btnStart.setEnabled(false);
      btnStop.setEnabled(true);
      thread = new Thread(new MyClass(progress, this), 
                          "Wtek obliczeniowy");
      thread.start();
    }
    if ("Stop".equals(cmd)){
      btnStart.setEnabled(true);
      btnStop.setEnabled(false);
      thread.interrupt();
    }
  }
  public void updateProgress(int progress)
  {
    this.progress = progress;
    lblProgeess.setText(progress + "%");
    if(progress >= 100){
      btnStart.setEnabled(true);
      btnStop.setEnabled(false);
    }
  }
  public static void main(String args[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new Application();
      }
    });
  }
}
